#include <windows.h>
#include <stdio.h>
#include "rockey2.h"

void main()
{
	int retcode, handle, select, block_index;
	DWORD uid, hid;
	char buffer[512];

	do
	{
		printf("\n");
		printf("1. Generate UID\n");
		printf("2. Write Rockey2\n");
		printf("3. Read Rockey2\n");
		printf("4. Exit\n");
		printf("Please input select : ");
		scanf("%d", &select);
		fflush(stdin);
		// generate UID
		if (select == 1)
		{
			retcode = RY2_Find();
			if (retcode < 0)
			{
				printf("ERROR of find: %08x\n", retcode);
				return;
			}
			if (retcode == 0)
			{
				printf("ERROR: Not found any rockey2\n");
				return;
			}

	// There must be one dongle pluging in computer when generating UID,so we don't care the UID and
	//  HID of it .We only use the first dongle.
			retcode = RY2_Open(AUTO_MODE, 0, &hid);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			handle = retcode;

			printf("Please input seed : ");
			scanf("%s", buffer);
			retcode = RY2_GenUID(handle, &uid, buffer, ROCKEY2_DISABLE_WRITE_PROTECT);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			printf("\nUID is %d\n", uid);
			RY2_Close(handle);

			// after generated new UID, the flag of dongle has changed,you must plug out it and re-plug again
			printf("You must plug out Rockey2 and re-plug to enable new uid.\n");
		}

		//  write dongle with appointed UID
		if (select == 2)
		{
			retcode = RY2_Find();
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			if (retcode == 0)
			{
				printf("ERROR: Not found any rockey2\n");
				return;
			}

			printf("please input uid : ");
			uid=0;
			scanf("%d", &uid);
			fflush(stdin);
			hid=0;
			retcode = RY2_Open(1, uid, &hid);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			handle = retcode;

			printf("Please input write block index(0-4) : ");
			scanf("%d", &block_index);
			printf("Please input write data : ");
			fflush(stdin);
			scanf("%[^\n]", buffer);
			retcode = RY2_Write(handle, block_index, buffer);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			printf("Write OK\n");
			RY2_Close(handle);
		}

		//read dongle with appointed UID
		if (select == 3)
		{
			retcode = RY2_Find();
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			if (retcode == 0)
			{
				printf("ERROR: Not found any rockey2\n");
				return;
			}

			printf("please input uid : ");
			scanf("%d", &uid);
			fflush(stdin);
			retcode = RY2_Open(1, uid, &hid);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			handle = retcode;

			printf("Please input read block index(0-4) : ");
			scanf("%d", &block_index);
			fflush(stdin);
			retcode = RY2_Read(handle, block_index, buffer);
			if (retcode < 0)
			{
				printf("ERROR: %08x\n", retcode);
				return;
			}
			printf("Readed data: %s\n", buffer);
			RY2_Close(handle);
		}
	} while(select != 4);
}
